#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;

using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{
	[TestFixture]
	public class BOL_MSBOSComponentClass : BaseTest 
	{
		private BOL.MsbosComponentClass _tstMCC;
		private BOL.MsbosComponentClass _tstMCCByRow;
		private DataTable _dtMsbosCC;
		private DataRow _drMsbosCC;
		

		[SetUp]
		protected void SetUp() 
		{
			this.BaseSetUp();

			if (this.RefreshData)
			{
				this._dtMsbosCC = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM MsbosComponentClass ORDER BY LastUpdateDate DESC", false);
				if (this._dtMsbosCC.Rows.Count == 0)
				{
					DataSet tmpDS = new DataSet();
					DataTable dtM = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM Msbos WHERE DivisionCode = '" + this.TestDivisionCode + "'");

					tmpDS.Tables.Add(dtM);
					
					this._dtMsbosCC.Columns.Remove(TABLES.MsbosComponentClass.RowVersion);

					DataRow drNewCC = this._dtMsbosCC.NewRow();
					drNewCC[TABLES.MsbosComponentClass.ComponentClassId] = 1;
					drNewCC[TABLES.MsbosComponentClass.MaximumSetupUnitQuantity] = 1;
					drNewCC[TABLES.MsbosComponentClass.MsbosComponentClassGuid] = Guid.NewGuid();
					drNewCC[TABLES.MsbosComponentClass.MsbosGuid] = (System.Guid)dtM.Rows[0][TABLES.Msbos.MsbosGuid];
					drNewCC[TABLES.MsbosComponentClass.RecordStatusCode] = "A";
					this._dtMsbosCC.Rows.Add(drNewCC);
					tmpDS.Tables.Add(this._dtMsbosCC);

					BOL.Msbos tmpM = new Msbos();
					tmpM.Save(tmpDS, COMMON.UpdateFunction.UnitTests);
				}

				this._dtMsbosCC = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM MsbosComponentClass ORDER BY LastUpdateDate DESC", true);
				this._drMsbosCC = this._dtMsbosCC.Rows[0];

				this.RefreshData = false;
			}
			
			_tstMCC = new BOL.MsbosComponentClass();
			_tstMCCByRow = new BOL.MsbosComponentClass(this._drMsbosCC);
		}


		[Test]
		public void Ctor_Pass()
		{			
			_tstMCC = new BOL.MsbosComponentClass();
			Assert.IsNotNull(_tstMCC);
		}
        
		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_Fail()
		{	
		}

		[Test]
		public void Ctor_DataRow_Pass()
		{	
			BOL.MsbosComponentClass _tstMCC1 = new BOL.MsbosComponentClass();
			_tstMCC1.MaximumSetupUnitQuantity = Convert.ToInt16(_drMsbosCC["MaximumSetupUnitQuantity"]);
			//
			BOL.MsbosComponentClass _tstMCC2 = new BOL.MsbosComponentClass(this._drMsbosCC);
			//
			Assert.AreEqual(_tstMCC1.MaximumSetupUnitQuantity,_tstMCC2.MaximumSetupUnitQuantity);
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(ArgumentException))]
		public void Ctor_DataRow_Fail()
		{	
			BOL.MsbosComponentClass _tstMCC1 = new BOL.MsbosComponentClass(new DataTable().NewRow());
		}

		
		[Test]
		public void LoadDataRowFromThis_Pass()
		{			
			DataRow dr1 = this._dtMsbosCC.NewRow();

			DataRow dr2 = this._tstMCC.LoadDataRowFromThis(dr1);

			Assert.AreEqual(dr1, dr2);
		}
        
		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void LoadDataRowFromThis_Fail()
		{	
		}

		[Test]
		public void MsbosComponentClassGuid_Pass()
		{			
			System.Guid tstValue = System.Guid.NewGuid();

			this._tstMCC.MsbosComponentClassGuid = tstValue;

			Assert.AreEqual(this._tstMCC.MsbosComponentClassGuid, tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void MsbosComponentClassGuid_Fail()
		{			
		}

		[Test]
		public void MsbosGuid_Get()
		{			
			Guid _msbosGuid = _tstMCC.MsbosGuid;
			Assert.AreEqual(_tstMCC.MsbosGuid,_msbosGuid);
			//	
			_msbosGuid = _tstMCCByRow.MsbosGuid;
			Assert.AreEqual(_tstMCCByRow.MsbosGuid,_msbosGuid);
		}

		[Test]
		public void MsbosGuid_Set()
		{			
			Guid _msbosGuid = Guid.Empty;
			_tstMCC.MsbosGuid = _msbosGuid;
			Assert.AreEqual(_msbosGuid,_tstMCC.MsbosGuid);
			//
			_msbosGuid = Guid.NewGuid();
			_tstMCC.MsbosGuid = _msbosGuid;
			Assert.AreEqual(_msbosGuid,_tstMCC.MsbosGuid);
		}

		[Test]
		public void ComponentClassID_Get()
		{			
			int _componentClassId = _tstMCC.ComponentClassId;
			Assert.AreEqual(_tstMCC.ComponentClassId,_componentClassId);
			//	
			_componentClassId = _tstMCCByRow.ComponentClassId;
			Assert.AreEqual(_tstMCCByRow.ComponentClassId,_componentClassId);
		}

		[Test]
		public void ComponentClassID_Set_Pass()
		{			
			int _componentClassId = 1;
			_tstMCC.ComponentClassId = _componentClassId;
			Assert.AreEqual(_componentClassId,_tstMCC.ComponentClassId);
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(BusinessObjectException))]
		public void ComponentClassID_Set_Fail()
		{			
			int _componentClassId = -1;
			_tstMCC.ComponentClassId = _componentClassId;
		}

		[Test]
		public void MaximumSetupUnitQuantity_Get()
		{			
			short _maxQuantity = _tstMCC.MaximumSetupUnitQuantity;
			Assert.AreEqual(_tstMCC.MaximumSetupUnitQuantity,_maxQuantity);
			//	
			_maxQuantity = _tstMCCByRow.MaximumSetupUnitQuantity;
			Assert.AreEqual(_tstMCCByRow.MaximumSetupUnitQuantity,_maxQuantity);
		}

		[Test]
		public void MaximumSetupUnitQuantity_Set_Pass()
		{			
			short _maxQuantity = (short)1;
			_tstMCC.MaximumSetupUnitQuantity = _maxQuantity;
			Assert.AreEqual(_maxQuantity,_tstMCC.MaximumSetupUnitQuantity);
			//
			_maxQuantity = (short)99;
			_tstMCC.MaximumSetupUnitQuantity = _maxQuantity;
			Assert.AreEqual(_maxQuantity,_tstMCC.MaximumSetupUnitQuantity);
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(BusinessObjectException))]
		public void MaximumSetupUnitQuantity_Set_Fail()
		{			
			short _maxQuantity = short.MinValue;
			_tstMCC.MaximumSetupUnitQuantity = _maxQuantity;
		}

		[Test]
		public void Clear_Pass()
		{	
			BOL.MsbosComponentClass _tstMCC3 = (BOL.MsbosComponentClass)_tstMCCByRow.Clone();
			_tstMCC3.Clear();
			Assert.AreEqual(Guid.Empty,_tstMCC3.MsbosGuid);
			Assert.AreEqual(-1,_tstMCC3.ComponentClassId);
			Assert.AreEqual((short)1,_tstMCC3.MaximumSetupUnitQuantity);
			Assert.AreEqual(false,_tstMCC3.IsDirty);
			Assert.AreEqual(true,_tstMCC3.IsNew);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Clear_Fail()
		{
		}

		[Test]
		public void ComponentClassName_Pass()
		{	
			string className="CRYOPRECIPITATE";

			_tstMCCByRow.ComponentClassName=className;

			Assert.AreEqual( _tstMCCByRow.ComponentClassName, className );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ComponentClassName_Fail()
		{
		}

		[Test]
		public void RecordStatusCode_Pass()
		{	
			_tstMCCByRow.RecordStatusCode=Common.RecordStatusCode.LocalEntry;

			Assert.AreEqual( _tstMCCByRow.RecordStatusCode, Common.RecordStatusCode.LocalEntry );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void RecordStatusCode_Fail()
		{
		}


	}
}
#endif

